% This is ambisym.cls for the Ambisonics Symposium 2009

\NeedsTeXFormat{LaTeX2e}
%\ProvidesClass{ambisym}[2009 Ambisonics Symposium paper style]
%\DeclareOption*{\PassOptionsToClass{\CurrentOption}{aaaa}}

%\ProcessOptions\relax
\LoadClass[a4paper,twocolumn,10pt]{article}
\RequirePackage{titlesec}
\RequirePackage[left=2.5cm,right=1.5cm,top=2.5cm,bottom=2.5cm]{geometry}
\RequirePackage{parskip}
\RequirePackage{balance}
\RequirePackage[labelfont=bf]{caption}
\RequirePackage{color}
\RequirePackage{lastpage}
\RequirePackage{fancyhdr}
\RequirePackage{hyperref}
\definecolor{ambiblue}{rgb}{0.129,0.129,0.324}
\hypersetup{linkcolor=black,
        linkcolor=black,
        urlcolor=black,
        citecolor=black,
        breaklinks=true,
        colorlinks=true
}
\fancyhf{}
\cfoot{Page \thepage of \pageref{LastPage}}
\renewcommand{\headrulewidth}{0pt}
\renewcommand{\footrulewidth}{0pt}
%\RequirePackage{uarial}
\titleformat{\section}{\normalsize\bfseries\center}{\thesection.}{1ex}{}{}
\titleformat{\subsection}{\normalsize\bfseries}{\thesubsection.}{1ex}{}
\titleformat{\paragraph}{\normalsize\em}{}{0ex}{}
%\titleformat{<command>}[<shape>]{<format>}{<label>}{<sep>}{<before>}[<after>]
\setlength\baselineskip{.89\baselineskip}
\titlespacing{\section}{0pt}{\baselineskip}{0pt}
\titlespacing{\subsection}{0pt}{0pt}{0pt}
\titlespacing{\paragraph}{0pt}{0pt}{-\baselineskip}
\setlength\parskip{0.5\baselineskip}
\setlength\footskip{\baselineskip}

%no titlepage:
\renewcommand\maketitle{\par
  \begingroup
    \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
    \def\@makefnmark{\rlap{\@textsuperscript{\normalfont\@thefnmark}}}%
    \long\def\@makefntext##1{\parindent 1em\noindent
            \hb@xt@1.8em{%
                \hss\@textsuperscript{\normalfont\@thefnmark}}##1}%
    \if@twocolumn
      \ifnum \col@number=\@ne
        \@maketitle
      \else
        \twocolumn[\@maketitle]%
      \fi
    \else
      \newpage
      \global\@topnum\z@   % Prevents figures from going at top of page.
      \@maketitle
    \fi
    \thispagestyle{empty}\@thanks
  \endgroup
  \setcounter{footnote}{0}%
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@maketitle\relax
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
}

\def\@maketitle{%
  \newpage
  \null
  \vspace{-34pt}
  \begin{minipage}{0.0\textwidth}
	\begin{center}
	~
	\end{center}
	\end{minipage}
  \begin{minipage}{0.2\textwidth}
	\begin{flushleft}
	\includegraphics[width=3cm]{sincp_ambi}
	\end{flushleft}
	\end{minipage}
	\begin{minipage}{0.0\textwidth}	
  \begin{flushright}
	
	\end{flushright}
	\end{minipage}
	\begin{minipage}{0.4\textwidth}
%	\begin{center}
	~\vspace{12pt}\\\textcolor{ambiblue}{\large \sffamily \scshape Ambisonics Symposium 2009}\\\textcolor{ambiblue}{\normalsize\sffamily June 25-27, Graz}
%	\end{center}
	\end{minipage}
	\vskip 12pt
	\hrule
  \vskip 24pt%
  \begin{center}%
  \let \footnote \thanks
  {\Large \bf\MakeUppercase{\@title} \par}%
    \vskip 1.5em%
    {\large
      \lineskip .5em%
      \begin{tabular}[t]{c}%
        \@author
      \end{tabular}\par}%
    \vskip 1em%
    {\large \@date}%
  \end{center}%
  \par}
  
    
\renewcommand\part{\par
   \addvspace{4ex}%
   \@afterindentfalse
   \secdef\@part\@spart}

\def\@part[#1]#2{%
    \ifnum \c@secnumdepth >\m@ne
      \refstepcounter{part}%
      \addcontentsline{toc}{part}{\thepart\hspace{1em}#1}%
    \else
      \addcontentsline{toc}{part}{#1}%
    \fi
    {\parindent \z@ \raggedright
     \interlinepenalty \@M
     \normalfont
     \ifnum \c@secnumdepth >\m@ne
       \Large\bfseries \partname~\thepart
       \par\nobreak
     \fi
     \huge \bfseries #2%
     \markboth{}{}\par}%
    \nobreak
    \vskip 3ex
    \@afterheading}
\def\@spart#1{%
    {\parindent \z@ \raggedright
     \interlinepenalty \@M
     \normalfont
     \huge \bfseries #1\par}%
     \nobreak
     \vskip 3ex
     \@afterheading}
     
     
     
\renewenvironment{thebibliography}[1]
     {\section*{\refname
        \@mkboth{\MakeUppercase\refname}{\MakeUppercase\refname}}%
      \list{\@biblabel{\@arabic\c@enumiv}}%
           {\settowidth\labelwidth{\@biblabel{#1}}%
            \leftmargin\labelwidth
            \advance\leftmargin\labelsep
            \@openbib@code
            \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand\theenumiv{\@arabic\c@enumiv}}%
      \sloppy
      \clubpenalty4000
      \@clubpenalty \clubpenalty
      \widowpenalty4000%
      \sfcode`\.\@m
      \setlength{\itemsep}{-0.5\baselineskip}}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}     
%}  
\renewenvironment{abstract}{				
				\pagestyle{empty}
				\maketitle
				\vspace{12pt}	
        {\bf\em \abstractname:}
        \em}
      {
      
			\vspace{12pt}
      }  
\newcommand{\keywords}[1]{\normalsize Key words: #1 \vspace{12pt}}

\renewcommand{\section}{\@startsection {section}{1}{\z@}%
                                   {-4ex \@plus -1ex \@minus -.2ex}%
                                   {6pt}%
                                   {\center\normalfont\fontsize{10pt}{5pt}\selectfont\bfseries\MakeUppercase}}
                                   
      
\renewcommand{\refname}{REFERENCES} 
\endinput